package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.Test;

public class BothTest extends CommonData {

	@Test
	public void flatMap_Map() {
		List<String> flatedList = listOfStringLists.stream().flatMap(Collection::stream).map(String::toUpperCase)
				.collect(Collectors.toList());
		assertEquals(2, listOfStringLists.size());
		assertEquals(6, flatedList.size());

	}

	@Test
	public void map_flatMap() {
		Function<String, Stream<String>> toUpper = item -> Stream.of(item.toUpperCase());

		lowerCaseStrings.stream().map(String::toLowerCase).flatMap(toUpper).forEach(item -> {
			System.out.println(item);
		});
		;
	}
}