package jcg.zheng.demo;

import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.Test;

public class FlatMapTest extends CommonData {

	private Stream<String> buildStreamOfUpperCaseString(List<String> item) {
		String[] test = new String[item.size()];

		for (int i = 0; i < test.length; i++) {
			test[i] = item.get(i).toUpperCase();
		}

		return Stream.of(test);
	}

	@Test
	public void testFlatMapWith2DArray() {
		Stream<String> stringStream = Arrays.stream(string2DArray).flatMap(Arrays::stream);

		assertEquals(3, string2DArray.length);

		assertEquals(6, stringStream.collect(Collectors.toList()).size());

	}

	@Test
	public void testFlatMapWithListofList() {
		Function<List<String>, Stream<String>> toUpperFlatMapFunction = this::buildStreamOfUpperCaseString;

		Stream.of(stringList2, stringList1, lowerCaseStrings).flatMap(toUpperFlatMapFunction)
				.forEach(System.out::println);
	}

	@Test
	public void testFlatMapWithListStream() {
		Stream<String> stringStream = Stream.of(stringList2, stringList1).flatMap(List::stream);

		assertEquals(3, stringList2.size());
		assertEquals(3, stringList1.size());

		assertEquals(6, stringStream.collect(Collectors.toList()).size());
	}

	@Test
	public void testFlatMapWithLongStream() {

		Function<List<String>, Stream<Long>> countFlatMapFunction = item -> Stream.of(item.stream().count());

		Stream.of(stringList2, stringList1, lowerCaseStrings).flatMap(countFlatMapFunction)
				.forEach(System.out::println);
	}

	@Test
	public void testFlatMapWithUpperCaseString() {
		Function<String, Stream<String>> toUppderFlatMapFunction = item -> Stream.of(item.toUpperCase());

		stringList2.stream().flatMap(toUppderFlatMapFunction).forEach(System.out::println);
	}

}
