package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.junit.Test;

import jcg.zheng.demo.POJO;

public class MapTest extends CommonData {

	private Integer countNameLength(POJO pojo) {
		if (pojo != null && pojo.getName() != null) {
			return pojo.getName().length();
		}
		return Integer.valueOf(0);
	}

	@Test
	public void testMaptoInt() {
		ToIntFunction<POJO> intMapper = POJO::nameWordCount;

		int[] intArray = listOfObjects.stream().mapToInt(intMapper).toArray();
		assertEquals(listOfObjects.size(), intArray.length);
	 
	}

	@Test
	public void testMapWithListString() {
		List<Integer> listSizes = Stream.of(stringList2, stringList1).map(List::size).collect(Collectors.toList());

		assertEquals(2, listSizes.size());
		System.out.println(listSizes);

	}

	@Test
	public void testMapWithPOJO() {
		Function<POJO, Integer> countNameLength = POJO::nameWordCount;

		List<Integer> nameCounts = listOfObjects.stream().map(countNameLength).collect(Collectors.toList());

		assertEquals(nameCounts.size(), listOfObjects.size());

		nameCounts.forEach(s -> System.out.println(s));
	}

	@Test(expected = NullPointerException.class)
	public void testMapWithPOJO_Exception() {

		Function<POJO, Integer> transform = POJO::nameWordCount;

		listOfObjectWithNullNames.stream().map(transform).collect(Collectors.toList());

	}

	@Test
	public void testMapWithPOJO_handleRuntimeException() {
		Function<POJO, Integer> transform = this::countNameLength;

		List<Integer> nameCounts = listOfObjectWithNullNames.stream().map(transform).collect(Collectors.toList());

		assertEquals(nameCounts.size(), listOfObjectWithNullNames.size());

		nameCounts.forEach(s -> System.out.println(s));
	}

	@Test
	public void testMapWithString() {
		Function<String, String> toUpper = String::toUpperCase;

		List<String> allUppercase = lowerCaseStrings.stream().map(toUpper).collect(Collectors.toList());

		assertEquals(lowerCaseStrings.size(), allUppercase.size());

		assertTrue(allUppercase.contains("MARY"));
		assertTrue(allUppercase.contains("SOMETHING"));
		assertTrue(allUppercase.contains("END"));
	}

}
