package com.springboot.serverevents.controller;

import com.springboot.serverevents.model.GameOfThrone;
import com.springboot.serverevents.service.GameOfThroneService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

// Lombok annotation
// Causes lombok to generate a logger field.
@Slf4j
// Spring framework annotation
@RestController
@RequestMapping(value = "/api")
public class GameOfThroneRestController {

    @Autowired
    GameOfThroneService gameOfThroneService;

    // URL - http://localhost:10093/api/gameOfThroneStream
    @GetMapping(path = "/gameOfThroneStream", produces = MediaType.TEXT_EVENT_STREAM_VALUE)
    public Flux<GameOfThrone> gameOfThroneStream() {
        log.info("Returning the game of throne streaming events via flux mechanism.");
        return gameOfThroneService.getAllThronesFlux();
    }
}
