package com.springboot.serverevents.controller;

import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

// Lombok annotation
// Causes lombok to generate a logger field.
@Slf4j
// Spring framework annotation
@Controller
public class IndexController {

    private static final String INDEX_PAGE = "index";

    // URL - http://localhost:10093/
    @GetMapping(value = "/")
    public String index() {
        log.info("Returning the application's welcome page to the user.");
        return INDEX_PAGE;
    }
}
