package com.springboot.serverevents.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.stereotype.Component;

// Lombok annotations
// Causes lombok to generate toString(), equals(), hashCode(), getter() & setter(), and Required arguments constructor in one go.
@Data
// Causes lombok to implement the Builder design pattern for the Pojo class.
// Usage can be seen in GameOfThroneReactiveRepository.java -> get() method.
@Builder
// Causes lombok to generate a constructor with no parameters.
@NoArgsConstructor
// Causes lombok to generate a constructor with 1 parameter for each field in your class.
@AllArgsConstructor
// Spring framework annotation
@Component
public class GameOfThrone {

    String house;
    String character;
    String dragon;
    String city;

}
