package com.springboot.serverevents.repo;

import com.github.javafaker.Faker;
import com.springboot.serverevents.model.GameOfThrone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import reactor.core.publisher.Flux;

import java.time.Duration;
import java.util.Collections;
import java.util.List;

@Repository
public class GameOfThroneReactiveRepository {

    @Autowired
    private Faker faker;

    public Flux<GameOfThrone> findAll() {
        // Simulate the data streaming every 2 seconds.
        return Flux.interval(Duration.ofSeconds(2))
                .onBackpressureDrop()
                .map(interval -> get())
                .flatMapIterable(v -> v);
    }

    private List<GameOfThrone> get() {
        final GameOfThrone gameOfThrone = GameOfThrone.builder()
                .house(faker.gameOfThrones().house())
                .character(faker.gameOfThrones().character())
                .dragon(faker.gameOfThrones().dragon())
                .city(faker.gameOfThrones().city()).build();
        return Collections.singletonList(gameOfThrone);
    }
}
