package com.springboot.serverevents.service;

import com.springboot.serverevents.model.GameOfThrone;
import com.springboot.serverevents.repo.GameOfThroneReactiveRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

// Lombok annotation
// Causes lombok to generate a logger field.
@Slf4j
// Spring framework annotation
@Service
public class GameOfThroneService {

    @Autowired
    GameOfThroneReactiveRepository gameOfThroneReactiveRepository;

    public Flux<GameOfThrone> getAllThronesFlux() {
        log.info("Fetching the game of throne data from the persistent storage and sending back via the flux mechanism.");
        return gameOfThroneReactiveRepository.findAll();
    }
}
