function LoadGameOfThronesData() {
    this.source = null;
    this.start = function () {
        let gameOfThronesTable = document.getElementById("gameOfThrones");
        this.source = new EventSource("/api/gameOfThroneStream");
        this.source.addEventListener("message", function (event) {
            // These events are JSON, so parsing.
            let gameOfThrone = JSON.parse(event.data);

            let rowElement = gameOfThronesTable.getElementsByTagName("tbody")[0].insertRow(0);
            let cell0 = rowElement.insertCell(0);
            let cell1 = rowElement.insertCell(1);
            let cell2 = rowElement.insertCell(2);
            let cell3 = rowElement.insertCell(3);

            cell0.innerHTML = gameOfThrone.house;
            cell1.innerHTML = gameOfThrone.character;
            cell2.innerHTML = gameOfThrone.dragon;
            cell3.innerHTML = gameOfThrone.city;
        });

        this.source.onerror = function () {
            this.close();
        };
    };

    this.stop = function () {
        this.source.close();
    };
}

gameOfThrones = new LoadGameOfThronesData();

/*
 * Register callbacks for starting and stopping the SSE controller.
 */
window.onload = function () {
    gameOfThrones.start();
};
window.onbeforeunload = function () {
    gameOfThrones.stop();
}