package org.jcg.zheng.demo.jvm;

import java.util.Random;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoJVM {
	private static final Logger lOG = LoggerFactory.getLogger(DemoJVM.class);

	public static void main(String[] args) {
		lOG.info("DemoJVM starts");
		DemoJVM demo = new DemoJVM();

		if (args.length == 1) {
			if ("SO".equalsIgnoreCase(args[0])) {
				demo.infiniteLoop();
			} else if ("OM".equalsIgnoreCase(args[0])) {
				demo.outOfMemory();
			}  
		}

		int total = 0;
		for (int i = 0; i < 1000; i++) {
			total = demo.sumObject(String.valueOf(i), total);
		}

		demo.printRuntimeInfo();

		lOG.info("DemoJVM completes");
	}

	private String name;

	public String getName() {
		return name;
	}

	public int getNumber() {
		Random ran = new Random(10000);
		return ran.nextInt();
	}

	public void infiniteLoop() {
		infiniteLoop();
	}

	public float[][] outOfMemory() {
		//float takes 4 bytes, so this float array takes about 4MB memory
		float[][] ft = new float[1024][1024];
		return ft;
	}

	public void printRuntimeInfo() {
		long MEGABYTE = 1024L * 1024L;
		lOG.info("JVM version =  " + Runtime.version());
		lOG.info("JVM available processors = " + Runtime.getRuntime().availableProcessors());
		lOG.info("JVM free Memory in MB = " + Runtime.getRuntime().freeMemory() / MEGABYTE);
		lOG.info("JVM max Memory in MB = " + Runtime.getRuntime().maxMemory() / MEGABYTE);
		lOG.info("JVM total Memory in MB = " + Runtime.getRuntime().totalMemory() / MEGABYTE);
		lOG.info("*****");
		lOG.info("getSystemClassLoader= " + ClassLoader.getSystemClassLoader().getName());
		lOG.info("getPlatformClassLoader=" + ClassLoader.getPlatformClassLoader().getName());
		lOG.info("Classloader:" + this.getClass().getClassLoader());
	}

	public void setName(String name) {
		this.name = name;
	}

	public int sumObject(String name, int totalBefore) {
		DemoJVM pojo = new DemoJVM();
		pojo.setName(name);
		try {
			Thread.sleep(500);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		return totalBefore + pojo.getNumber();
	}

}
