package org.javacodegeeks;

import org.quartz.*;
import org.quartz.impl.StdSchedulerFactory;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

import static org.quartz.JobBuilder.newJob;
import static org.quartz.TriggerBuilder.newTrigger;

public class UpdateTriggerExample {

    public static void main(String[] args) {
        UpdateTriggerExample deleteJobExample = new UpdateTriggerExample();
        deleteJobExample.run();
    }

    private void run() {

        // First we must get a reference to a scheduler
        SchedulerFactory schedulerFactory = new StdSchedulerFactory();
        try {
            Scheduler scheduler = schedulerFactory.getScheduler();

            // define the job and tie it to our HelloJob class
            JobDetail job = newJob(ExampleJob.class).withIdentity("MyJobName", "MyJobGroup").build();

            // Trigger the job to run after 3 seconds
            Date date = Date.from(LocalDateTime.now().plusSeconds(2).atZone(ZoneId.systemDefault()).toInstant());
            Trigger trigger = newTrigger().withIdentity("MyTriggerName", "MyTriggerGroup").startAt(date).build();

            trigger.getJobDataMap().put("triggerUpdated", false);
            // Tell quartz to schedule the job using our trigger
            scheduler.scheduleJob(job, trigger);
            System.out.println("Trigger Updated: " + scheduler.getTrigger(trigger.getKey()).getJobDataMap().getBoolean("triggerUpdated"));

            trigger.getJobDataMap().put("triggerUpdated", true);

            scheduler.rescheduleJob(trigger.getKey(), trigger);
            System.out.println("Trigger Updated: " + scheduler.getTrigger(trigger.getKey()).getJobDataMap().getBoolean("triggerUpdated"));

            // Start up the scheduler (nothing can actually run until the scheduler has been started)
            scheduler.start();
            try {
                Thread.sleep(4*1000);
            } catch (Exception e) {
            }

            // Shutdown the scheduler
            scheduler.shutdown(true);

        } catch (SchedulerException e) {
            e.printStackTrace();
        }
    }
}
