# Insert a single record in the table
# Insert with all the values and columns specified except EMP_ID.
INSERT INTO EMPLOYEES (FIRST_NAME,LAST_NAME,BIRTH_DATE,HIRE_DATE)
values('Thorin','Oakenshield','2746-01-01','2760-05-01');

#Insert all columns without naming columns.
#We need to put Default for EMP_ID as it is Auto_Increment.
INSERT INTO EMPLOYEES
values(default,'Thrain','Oakenshield','2850-01-01','2910-05-01');

#Insert with Null values
INSERT INTO EMPLOYEES (FIRST_NAME,BIRTH_DATE,HIRE_DATE)
values('Kili','3000-01-01','3010-05-01');

#Insert with specific column value. inserted with default value for date of birth
INSERT INTO EMPLOYEES (FIRST_NAME,HIRE_DATE)
values('Smaug','2600-05-01');

#inserting incorrect values in Employees table
INSERT INTO EMPLOYEES(LAST_NAME,BIRTH_DATE,HIRE_DATE)
VALUES('Oakenshield','2650-09-12','3010-07-15');

#Output for the Employees table
SELECT * FROM EMPLOYEES;

#Insert multiple values into table DEPARTMENTS
#Department_ID is auto_increment.
INSERT INTO DEPARTMENTS (DEPT_NAME)
values
('Logistics'),
('Support'),
('Development'),
('Transport');

#Insert into table with Foreign keys
INSERT INTO EMPLOYEE_DEPT (EMP_ID,DEPT_ID,FROM_DATE,TO_DATE)
VALUES (1,3,'2760-05-15','2800-10-15');

#Insert with incorrect foreign keys
INSERT INTO EMPLOYEE_DEPT (EMP_ID,DEPT_ID,FROM_DATE,TO_DATE)
VALUES (3,10,'2765-05-15','2900-10-15');

#insert using a select query- columns specified
INSERT INTO EMPLOYEES2 (EMP_ID,FIRST_NAME,LAST_NAME,BIRTH_DATE,HIRE_DATE)
SELECT EMP_ID,FIRST_NAME,LAST_NAME,BIRTH_DATE,HIRE_DATE FROM EMPLOYEES WHERE EMP_ID =1;

#OR
#Insert into select query no columns specified
INSERT INTO EMPLOYEES2 (EMP_ID,FIRST_NAME,LAST_NAME,BIRTH_DATE,HIRE_DATE)
SELECT * FROM EMPLOYEES WHERE EMP_ID =2;

#Dump all records from one table to another
INSERT INTO EMPLOYEES2 (EMP_ID,FIRST_NAME,LAST_NAME,BIRTH_DATE,HIRE_DATE)
SELECT * FROM EMPLOYEES;

#Duplicate Primary key violation. 
INSERT INTO EMPLOYEES2 (EMP_ID,FIRST_NAME)
VALUES (4,'Bofur');

#Insert on Duplicate key syntax
INSERT INTO EMPLOYEES2 (EMP_ID,FIRST_NAME)
VALUES (4,'Smaug')
ON DUPLICATE KEY UPDATE LAST_NAME="The Fierce";


