package jcg.examples.quadsolver;

public class QuadSolver
{
    public static double[][] solve(double a, double b, double c)
    {
        double[][] roots = new double[2][2];
        double d = b * b - 4 * a * c;
        if (d > 0) {
            roots[0][0] = (0 - b + Math.sqrt(d)) / (2 * a);
            roots[1][0] = (0 - b - Math.sqrt(d)) / (2 * a);
        } else {
            roots[0][0] = roots[1][0] = 0 - (b / (2 * a));
            if (d != 0) {
                // d < 0
                roots[0][1] = Math.sqrt(0 - d) / (2 * a);
                roots[1][1] = 0 - roots[0][1];
            }
        }
        return roots;
    }
}
