/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package jcg.examples.quadsolver;

import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 *
 * @author Kevin
 */
public class QuadraticSolveImplrNGTest
{
    
    public QuadraticSolveImplrNGTest()
    {
    }

    @BeforeClass
    public static void setUpClass() throws Exception
    {
    }

    @AfterClass
    public static void tearDownClass() throws Exception
    {
    }

    @BeforeMethod
    public void setUpMethod() throws Exception
    {
    }

    @AfterMethod
    public void tearDownMethod() throws Exception
    {
    }

    /**
     * Test of solve method, of class QuadSolver.
     */   
    @Test
    public void testSolve1(){
        testSolve(2, 3, 5, 
            new double[]{-0.75, Math.sqrt(31)/4},
            new double[]{-0.75, 0-Math.sqrt(31)/4});
    }
    @Test
    public void testSolve2(){
        testSolve(1, 3, 1, 
            new double[]{(-3 + Math.sqrt(5))/2,0},
            new double[]{(-3 - Math.sqrt(5))/2, 0});
    }
    
    @Test
    public void testSolve3(){
        testSolve(1,2,1,
                new double[]{-1,0}, new double[]{-1,0});
    }
    private void testSolve(double a, double b, double c, double[] expRoot1, double[] expRoot2)
    {
        System.out.printf("solve %fx^2 + %fdx + %f = 0", a, b, c);
        double[][] roots = QuadSolver.solve(a, b, c);
        final double delta = 1E-13;
        try {
            Assert.assertArrayEquals(expRoot1, roots[0], delta);
            Assert.assertArrayEquals(expRoot2, roots[1], delta);
        } catch (AssertionError ae){
            Assert.assertArrayEquals(expRoot2, roots[0], delta);
            Assert.assertArrayEquals(expRoot1, roots[1], delta);
        }
    }    
}
