package LibraryPackage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ApplicationClass {

	public static void main(String[] args) {

		BufferedReader input = new BufferedReader(new InputStreamReader(System.in));

		BookManager bm = new BookManager();
		String inputName = "";

		while (true) {
			System.out.println("==== Book Manager ====");
			System.out.println("     1) View all Books");
			System.out.println("     2) Add a Book");
			System.out.println("     3) Edit a Book");
			System.out.println("     4) Search for a Book");
			System.out.println("     5) Exit");
			System.out.println("");
			System.out.print("Please choose from the options View, Add, Edit, Search or Exit:");
			try {
				String str = input.readLine();
				int choice = Options.getAction(str);

				switch (choice) {
				case 1:
					bm.viewAllBooks();
					break;
				case 2:
					System.out.println("==== Add a Book ====");
					bm.addBook();
					break;
				case 3:
					System.out.println("==== Edit a Book ====");
					bm.editBook();
					break;
				case 4:
					System.out.println("Enter the name of the book to search:");
					try {
						inputName = input.readLine();
						if (!inputName.isEmpty()) {
							bm.searchBook(inputName);
						}
					} catch (IOException e) {
						e.printStackTrace();
					}

					break;
				case 5:
					System.out.println("All changes saved!");
					input.close();
					System.exit(0);
					break;
				default:
					System.out.println("Invalid choice!Please pick an option from View, Add, Edit, Search or Exit");
					break;

				}
			} catch (IOException e) {
				e.printStackTrace();
			}

		}

	}


	public static enum Options{
		VIEW(1),
		ADD(2),
		EDIT(3),
		SEARCH(4),
        EXIT(5);
        
        private int action;

        public static int getAction(String input){
            int out = 0;
            Options[] values = Options.values();

            for(Options val : values){
                if(input.toUpperCase().contains(val.name())){
                    out = val.action; 
                }
                   
           }
           return out;

        }

        Options(int val){
            action = val;
        }
	}
}

