package com.springboot.methodlevel.security.bootstrap;

import com.springboot.methodlevel.security.entity.Role;
import com.springboot.methodlevel.security.entity.User;
import com.springboot.methodlevel.security.service.UserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

//lombok annotation
@Slf4j
//spring annotation
@Component
public class DefaultUsersLoader implements CommandLineRunner {

    @Autowired
    UserService service;
    @Autowired
    BCryptPasswordEncoder passwordEncoder;

    @Override
    public void run(String... args) {
        loadUsers();
    }

    private void loadUsers() {
        if (!service.areDefaultUsersPresent()) {
            log.info("Saving default users in the db");
            service.saveAll(createUsers());
        } else {
            log.info("Default users already exists in db");
        }
    }

    private List<User> createUsers() {
        final List<User> users = new ArrayList<>();
        users.add(create("user", Collections.singletonList(Role.ROLE_USER)));
        users.add(create("moderator", Collections.singletonList(Role.ROLE_MODERATOR)));
        users.add(create("admin", Collections.singletonList(Role.ROLE_ADMIN)));
        users.add(create("owner", Arrays.asList(Role.ROLE_MODERATOR, Role.ROLE_ADMIN)));

        return users;
    }

    private User create(final String username, final List<Role> roles) {
        return User.builder()
                .username(username)
                //for simplicity we are keeping the same password for all users.
                //in ideal case this should be different for each user.
                .password(passwordEncoder.encode("password01"))
                .active(true)
                .roles(roles)
                .build();
    }
}
