package com.springboot.methodlevel.security.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Component;

//spring annotation
@Component
//spring security annotations
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled = true, securedEnabled = true)
public class SecurityConfig extends WebSecurityConfigurerAdapter {

    private static final String[] WHITELIST_PATTERNS = {"/api/anonymous", "/h2-console/**"};

    @Qualifier("customUserDetailsService")
    @Autowired
    UserDetailsService detailsService;

    @Override
    protected void configure(final AuthenticationManagerBuilder auth) throws Exception {
        //using the user details service to authenticate the user from the db
        auth.userDetailsService(detailsService);
    }

    @Override
    protected void configure(final HttpSecurity http) throws Exception {
        http.httpBasic()    // using the basic authentication
                .and().authorizeRequests().antMatchers(WHITELIST_PATTERNS).permitAll()      //public endpoints
                .and().authorizeRequests().anyRequest().authenticated()     // all other application endpoints are protected
                .and().csrf().disable().headers().frameOptions().sameOrigin();
        //do not create a session
        //effective for rest api's
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
    }

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }
}
