package com.springboot.methodlevel.security.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.stereotype.Component;

import javax.persistence.*;
import java.util.List;

//spring jpa annotations
@Entity
@Table(name = "user_authentication")
//lombok annotation
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
//spring annotation
@Component
public class User {

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    int id;
    @Column(name = "user_name", nullable = false)
    String username;
    String password;
    boolean active;
    @Enumerated(EnumType.STRING)
    @ElementCollection(fetch = FetchType.EAGER)
    List<Role> roles;
}
