package com.springboot.methodlevel.security.service;

import com.springboot.methodlevel.security.entity.CustomUserDetails;
import com.springboot.methodlevel.security.entity.User;
import com.springboot.methodlevel.security.repository.UserRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

import java.util.Optional;

//lombok annotation
@Slf4j
//spring annotation
@Service
public class CustomUserDetailsService implements UserDetailsService {

    @Autowired
    UserRepository repository;

    //find user by username from the db
    @Override
    public UserDetails loadUserByUsername(final String username) throws UsernameNotFoundException {
        log.info("Fetching user = {}", username);
        final Optional<User> optionalUser = repository.findByUsername(username);
        return optionalUser.map(CustomUserDetails::new).orElseThrow(
                () -> new UsernameNotFoundException(String.format("User = %s does not exists", username)));
    }
}
