package com.springboot.methodlevel.security.service;

import com.springboot.methodlevel.security.dto.UserDto;
import com.springboot.methodlevel.security.entity.User;
import com.springboot.methodlevel.security.repository.UserRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

//lombok annotation
@Slf4j
//spring annotation
@Service
public class UserService {

    @Autowired
    UserRepository repository;

    //get users count from the db
    public boolean areDefaultUsersPresent() {
        return repository.count() > 0;
    }

    //save all users in the db
    public void saveAll(final List<User> users) {
        repository.saveAll(users);
    }

    //get all users from the db
    public List<UserDto> getUsers() {
        log.info("Fetching all users from the db");
        final List<User> users = repository.findAll();
        //checking the null and empty check
        if (CollectionUtils.isEmpty(users)) {
            log.info("Returning an empty list");
            return Collections.emptyList();
        }

        return users.stream().map(user -> new UserDto(user.getId(), user.getUsername(), user.isActive(),
                user.getRoles())).collect(Collectors.toList());
    }
}
