USE SAKILA;

#SUBQUERY AS A SCALAR OPERAND
SELECT (SELECT CITY FROM CITY WHERE CITY_ID=2) FROM ADDRESS WHERE CITY_ID=2;

#SUB QUERY WITH OPERATORS
SELECT F.TITLE
	FROM FILM AS F
	WHERE F.LANGUAGE_ID = (SELECT LANGUAGE_ID FROM LANGUAGE WHERE NAME = 'ENGLISH')
	AND F.TITLE LIKE 'I%' OR 'L%' ;

#SUBQUERY EXAMPLE 2 WITH OPERATORS 
SELECT TITLE,RENTAL_RATE,REPLACEMENT_COST,RATING FROM FILM 
WHERE REPLACEMENT_COST >= (SELECT AVG(REPLACEMENT_COST) FROM FILM);

# IN QUERY
SELECT F.TITLE,F.DESCRIPTION,F.LENGTH,F.RATING,GROUP_CONCAT(CONCAT(A.FIRST_NAME,A.LAST_NAME) SEPARATOR ', ') AS `ACTORS`
FROM FILM_ACTOR FA, FILM F ,ACTOR A
WHERE F.FILM_ID = FA.FILM_ID 
AND A.ACTOR_ID = FA.ACTOR_ID
AND F.FILM_ID IN (
    SELECT FILM_ID FROM FILM_CATEGORY, CATEGORY
    WHERE CATEGORY.CATEGORY_ID = FILM_CATEGORY.CATEGORY_ID
    AND CATEGORY.CATEGORY_ID = 6)
GROUP BY F.FILM_ID;

#SUBQUERY WITH ORDER BY CLAUSE
SELECT * FROM ACTOR
WHERE ACTOR_ID NOT IN 
	(SELECT ACTOR_ID FROM FILM_ACTOR
	 WHERE FILM_ID IN (506,605,939))
ORDER BY FIRST_NAME;
    
#DOUBLE NESTED SUBQUERIES
SELECT CONCAT(FIRST_NAME,' ',LAST_NAME) AS 'ACTORS'
FROM ACTOR
WHERE ACTOR_ID IN 
	(SELECT ACTOR_ID FROM FILM_ACTOR WHERE FILM_ID = 
            (SELECT FILM_ID FROM FILM WHERE TITLE = 'BREAKFAST GOLDFINGER'));
  
#NESTED SUBQUERIES EXAMPLE 2
SELECT SUM(AMOUNT) AS "TOTAL SALES"
FROM PAYMENT
WHERE RENTAL_ID IN (SELECT RENTAL_ID FROM RENTAL
       WHERE INVENTORY_ID IN 
            (SELECT INVENTORY_ID FROM INVENTORY
             WHERE FILM_ID IN 
                   (SELECT FILM_ID FROM FILM
                    WHERE FILM_ID IN 
                          (SELECT FILM_ID FROM FILM_CATEGORY
                            WHERE CATEGORY_ID IN 
                                  (SELECT CATEGORY_ID FROM CATEGORY)))));
       

CREATE TABLE CUST_PAYMENTS(
    CUSTOMER_ID SMALLINT UNSIGNED,
    FULLNAME VARCHAR(50),
    AMOUNT INT,
    NUMBER_OF_PAYMENTS INT
);

#INSERT WITH SUBQUERY
INSERT INTO CUST_PAYMENTS 
SELECT CUSTOMER_ID, CONCAT(FIRST_NAME, " ", LAST_NAME) AS NAME, AMOUNT, COUNT(AMOUNT) 
FROM CUSTOMER 
JOIN PAYMENT P1 USING(CUSTOMER_ID) 
WHERE AMOUNT > 
      (SELECT AVG(AMOUNT) FROM PAYMENT P2 WHERE P2.CUSTOMER_ID=P1.CUSTOMER_ID) 
GROUP BY CUSTOMER_ID;

#Update with Subquery
SELECT * FROM ADDRESS WHERE CITY_ID =58;


UPDATE ADDRESS
       SET DISTRICT = 'BATCAVE'
       WHERE CITY_ID IN (SELECT CITY_ID FROM CITY WHERE CITY = 'BATMAN' );


#Exists with Subquery
SELECT C.FIRST_NAME,C.LAST_NAME,A.ADDRESS,A.POSTAL_CODE
FROM CUSTOMER C,ADDRESS A
WHERE C.ACTIVE =1 
AND C.ADDRESS_ID = A.ADDRESS_ID
AND EXISTS (SELECT * 
            FROM CITY CT
            WHERE  CT.COUNTRY_ID IN (8,19,24,169) 
            AND CT.CITY_ID = A.CITY_ID);

#NOT EXISTS WITH SUBQUERY
SELECT * FROM INVENTORY WHERE
NOT EXISTS (
 SELECT 1 FROM RENTAL where RENTAL.INVENTORY_ID =10
 AND RETURN_DATE IS NULL
)
LIMIT 20;    


#USING SUBQUERIES WITH HAVING
SELECT * FROM FILM
WHERE FILM_ID NOT IN(
SELECT FILM_ID
FROM FILM JOIN FILM_CATEGORY USING (FILM_ID) JOIN CATEGORY USING (CATEGORY_ID)
GROUP BY CATEGORY.NAME
HAVING AVG(LENGTH) >= (SELECT AVG(LENGTH) FROM FILM))
AND FILM_ID NOT IN(
SELECT FILM_ID FROM INVENTORY
WHERE INVENTORY_ID IN (SELECT INVENTORY_ID FROM RENTAL WHERE INVENTORY_ID IS NULL));

# DERIVED TABLE
SELECT AVG(AVERAGES) FROM 
	(SELECT 
		CUSTOMER_ID,
		SUM(AMOUNT) AVERAGES
	FROM PAYMENT
	GROUP BY CUSTOMER_ID) AS TOTALS;

#YOU CANNOT USE THE SAME TABLE IN THE SUB-QUERY THAT YOU ARE DELETING FROM
DELETE FROM CUST_PAYMENTS WHERE CUSTOMER_ID IN (
SELECT CUSTOMER_ID FROM CUST_PAYMENTS WHERE NUMBER_OF_PAYMENTS <=5);

UPDATE  CUST_PAYMENTS 
SET AMOUNT = 13 
WHERE CUSTOMER_ID IN 
       (SELECT CUSTOMER_ID FROM CUST_PAYMENTS WHERE AMOUNT =11);
