#Implicit commit,DDL statement
START TRANSACTION;
SET AUTOCOMMIT = OFF;

 CREATE TABLE CUSTOMERS(
    CUSTOMER_ID INT AUTO_INCREMENT PRIMARY KEY,
    FIRST_NAME VARCHAR(20) NOT NULL,
    LAST_NAME VARCHAR(20),
    CUSTOMER_EMAIL VARCHAR(20),
    CUSTOMER_PHONE INTEGER,
    ENROLLMENT_DATE DATE DEFAULT (CURRENT_DATE())
 );
 
 rollback;

#Nested transactions not allowed
start transaction;
set autocommit = OFF;

insert into customers
 values
(default,'Thorin','Oakenshield','thorin.oakenshield@abc.com',NULL,default),
(default,'Bilbo','Baggins','bilbo.baggins@axz.com',1111111111,default),
(default,'Arwen','Noldor','bilbo.baggins@sdf.com',1111111111,default);
 
start transaction; 
update customers 
set customer_email = 'arwen.noldor@gmail.com',
    customer_phone = 1239087653
where first_name = 'Arwen';

rollback;
rollback;

#Another example of implicit commit
start transaction;
set autocommit = OFF;
update customers 
set customer_email = 'arwen.noldor@gmail.com',
    customer_phone = 1239087653
where first_name = 'Arwen';
start transaction;
set autocommit = OFF; 
delete * from customers;
commit;
rollback;

#savepoint transactions :: DMLs



#savepoint transactions :: DDLs
