# tagging sentences and counting them

# importing the counter module for counting the elements
from collections import Counter

# importing part of speech tagging module
from nltk import pos_tag

random_text = "Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has " \
              "been the industry's standard dummy text ever since the 1500s, when an unknown printer took " \
              "a galley of type and scrambled it to make a type specimen book. It has survived not only five " \
              "centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It " \
              "was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum " \
              "passages, and more recently with desktop publishing software like Aldus PageMaker including " \
              "versions of Lorem Ipsum.".split()

tags = pos_tag(random_text)
# print(tags)

# counting tags are important for the natural language operations
# counter is a container that keeps the count of each element present in the container
counts = Counter(tag for word, tag in tags)
print(counts)
