# python postgresql

import psycopg2
from psycopg2 import Error

from readdbconfig import *


def connect(database_name):
    try:
        # method will read the env file and return the config object
        params = read_db_params()
        db_name = params.get('DB', 'database') if not database_name else database_name

        # connect to database
        # reading the database parameters from the config object
        conn = psycopg2.connect(
            user=params.get('DB', 'username'),
            password=params.get('DB', 'password'),
            host=params.get('DB', 'host'),
            port=params.get('DB', 'port'),
            database=db_name
        )

        return conn
    except(Exception, Error) as error:
        print(error)


def print_version(conn):
    # creating a cursor to perform database operations
    cursor = conn.cursor()

    try:
        # execute the sql query
        cursor.execute('SELECT version();')

        # fetch result
        record = cursor.fetchone()
        print('PostgreSQL version = {}'.format(record))
    except(Exception, Error) as error:
        print(error)
    finally:
        if conn is not None:
            cursor.close()
            conn.close()
            print('\nDatabase connection closed.')


# driver code
if __name__ == '__main__':
    # ops method
    print_version(connect(''))
