# python postgresql

import psycopg2
from psycopg2 import Error

from readdbconfig import *


def connect(self):
    try:
        # connect to database
        conn = psycopg2.connect(
            user=self.get('DB', 'username'),
            password=self.get('DB', 'password'),
            host=self.get('DB', 'host'),
            port=self.get('DB', 'port'),
            database=self.get('DB', 'database')
        )

        print_version(conn)
    except(Exception, Error) as error:
        print(error)


def print_version(conn):
    # creating a cursor to perform database operations
    cursor = conn.cursor()

    try:
        # execute the sql query
        cursor.execute('SELECT version();')

        # fetch result
        record = cursor.fetchone()
        print('PostgreSQL version = {}'.format(record))
    except(Exception, Error) as error:
        print(error)
    finally:
        if conn is not None:
            cursor.close()
            conn.close()
            print('\nDatabase connection closed.')


# driver code
if __name__ == '__main__':
    db_params = read_db_params()
    connect(db_params)
