# python string contain() method tutorial

# import statement
import operator
# import statement
from re import search


# approach 1 - index()
def index(string, search_key):
    try:
        string.index(search_key)
        print('Found.')
    except ValueError:
        print('Search key not found.')


# approach 2 - find()
def find(string, search_key):
    if string.find(search_key) != -1:
        print('Found.')
    else:
        print('Search key not found.')


# approach 3 - count()
def count(string, search_key_1, search_key_2):
    x = string.count(search_key_1)
    print('Is search key 1 = {} present in the given string = {}'.format(search_key_1, x))

    y = string.count(search_key_2)
    print('Is search key 2 = {} present in the given string = {}'.format(search_key_2, y))


# approach 4 - replace()
def replace(string, old_word, new_word, no_of_occurrences):
    z = string.replace(old_word, new_word, no_of_occurrences)
    print('Replaced string = {}'.format(z))


# approach 5 - in operator
def in_operator(string, search_key):
    if search_key in string:
        print('Found.')
    else:
        print('Search key not found.')


# approach 6 - regex expression
def regex(string, search_key):
    if search(search_key, string):
        print('Found.')
    else:
        print('Search key not found.')


# approach 7 - using operator module
def operator_mod(string, search_key):
    if operator.contains(string, search_key):
        print('Found.')
    else:
        print('Search key not found.')


# main() method
def main():
    string = 'What am I even tripping for? Everything’s gonna work out exactly the way it’s supposed to'

    print('\n--- Approach 1 ---\n')
    index(string, 'tripping')

    print('\n--- Approach 2 ---\n')
    find(string, 'supposed')

    print('\n--- Approach 3 ---\n')
    count(string, 'tripping', 'done')

    print('\n--- Approach 4 ---\n')
    no_of_occurrences = 1
    replace(string, 'tripping', 'TRIPPING', no_of_occurrences)

    print('\n--- Approach 5 ---\n')
    in_operator(string, 'going')

    print('\n--- Approach 6 ---\n')
    regex(string, 'geek')

    print('\n--- Approach 7 ---\n')
    operator_mod(string, 'gonna')


# driver code
if __name__ == '__main__':
    main()