# python string find() tutorial
# a. Returns the first occurrence of the given value
# b. If not found returns -1

# Syntax - string.find(search_char, start, end)
# where,
# start is optional and default value is 0
# end is optional and default value is end of the string

string = 'Hello world! Welcome to javacodegeeks.'


def find(search_char):
    index = string.find(search_char)
    if index != -1:
        print('{} is present at index = {}'.format(search_char, index))
    else:
        print('{} is not present in string'.format(search_char))


def find_range(search_char, start, end):
    index = string.find(search_char, start, end)
    if index != -1:
        print('{} is present in the given range at index = {}'.format(search_char, index))
    else:
        print('{} is not present in string'.format(search_char))


# driver code
if __name__ == '__main__':
    find('w')
    find('y')
    find_range('e', 1, 10)
    find_range('x', 1, 5)
