# python translate() tutorial
# Returns a string where each character is mapped to its corresponding character
# in the translation table

# Syntax - string.translate(translation_table)
# where,
# translation_table contains the mapping between two characters and is created by maketrans()

# translation using maketrans() method
def translation(orig_string):
    print('Original string = {}'.format(orig_string))

    string1 = 'wxyz'
    string2 = 'efgh'
    translation_table = orig_string.maketrans(string1, string2)

    # translated string
    translated_string = orig_string.translate(translation_table)
    print('Translated string = {}'.format(translated_string))


# translation using manual translation
def manual_translation(orig_string):
    print('Original string = {}'.format(orig_string))

    # dictionary
    # http://sticksandstones.kstrom.com/appen.html
    translation_table = {117: None, 118: None, 119: None, 120: None, 121: 105}

    # translated string
    translated_string = orig_string.translate(translation_table)
    print('Translated string = {}'.format(translated_string))


# driver code
if __name__ == '__main__':
    random_string = 'uvwxyz'

    translation(random_string)
    print('\n')
    manual_translation(random_string)
