package com.springboot.cache.hazelcast.bootstrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import com.github.javafaker.Faker;
import com.springboot.cache.hazelcast.model.Employee;
import com.springboot.cache.hazelcast.service.EmployeeService;

import lombok.extern.slf4j.Slf4j;

//lombok annotation
@Slf4j
//spring stereotype annotation
@Component
public class DefaultEmployeesLoader implements CommandLineRunner {

	@Autowired
	private EmployeeService service;
	@Autowired
	private Faker faker;

	@Override
	public void run(String... args) throws Exception {
		if(service.getTotalEmployees() > 0) {
			log.info("Skipping insert");
		} else {
			log.info("Adding default employees");
			service.saveAll(employees());
		}
	}
	
	private List<Employee> employees() {
		final List<Employee> employees = new ArrayList<>();
		for(int i=0; i<5; i++) {
			employees.add(create());
		}
		
		return employees;
	}
	
	private Employee create() {
		final List<String> phoneNumbers = Arrays.asList(faker.phoneNumber().cellPhone(), 
				faker.phoneNumber().phoneNumber());
		return Employee.builder()
				.fullName(faker.name().fullName())
				.phoneNumbers(phoneNumbers)
				.workDepartment(faker.commerce().department())
				.build();
	}
}
