package com.springboot.cache.hazelcast.config;

import java.util.Locale;
import java.util.Map;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.github.javafaker.Faker;
import com.hazelcast.config.Config;
import com.hazelcast.config.ManagementCenterConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.springboot.cache.hazelcast.model.Employee;

//spring annotation
@Configuration
public class BeanConfig {

	@Bean
	public Faker faker() {
		return new Faker(new Locale("en-US"));
	}

	//hazelcast cache configuration
	@Bean
	public Config config() {
		final Config cfg = new Config();
		cfg.getGroupConfig().setName("dev");
		cfg.setManagementCenterConfig(manCenterCfg());
		return cfg;
	}

	@Bean
	public Map<Integer, Employee> employeeMap(final HazelcastInstance instance) {
		return instance.getMap("employeeMap");
	}

	@Bean
	public HazelcastInstance instance(final Config cfg) {
		return Hazelcast.newHazelcastInstance(cfg);
	}

	private ManagementCenterConfig manCenterCfg() {
		return new ManagementCenterConfig()
				.setEnabled(true)
				// port number should be same on which the hazelcast management center is running
				.setUrl("http://localhost:10080/hazelcast-mancenter");
	}
}
