package com.springboot.cache.hazelcast.controller;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

import com.springboot.cache.hazelcast.model.Employee;
import com.springboot.cache.hazelcast.service.EmployeeService;

import lombok.extern.slf4j.Slf4j;

//lombok annotation
@Slf4j
//spring annotation
@RestController
@RequestMapping(path = "/employee")
public class EmployeeController {

	@Autowired
	private EmployeeService service;
	@Autowired
	private Map<Integer, Employee> employeeMap;
	
	//get employee by id
	@GetMapping(path = "/get/{id}")
	@ResponseStatus(code = HttpStatus.OK)
	public Employee getEmployee(@PathVariable("id") int id) {
		//first check if employeeMap has the employee details for the given employee id
		//if yes then return it. else fetch ir from the database
		final Employee employee = Objects.nonNull(employeeMap.get(id)) ? employeeMap.get(id) 
				: service.getEmployee(id);
		return employee;
	}

	//get all employees
	@GetMapping(path = "/get")
	@ResponseStatus(code = HttpStatus.OK)
	public List<Employee> getEmployees() {
		//fetch all employees from the database
		final List<Employee> employees = service.getEmployees();
		if(CollectionUtils.isEmpty(employees)) {
			log.info("Returning empty list");
		} else {
			//add employee to the cache
			log.info("Adding employees to the cache");
			for(final Employee e : employees) {
				employeeMap.put(e.getId(), e);
			}
		}
		
		return employees;
	}
}
