package com.springboot.cache.hazelcast.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.springframework.stereotype.Component;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

//spring jpa annotations
@Entity
@Table(name = "employee")
//lombok annotations
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
//spring stereotype annotation
@Component
public class Employee implements Serializable {

	@Id
	@GeneratedValue(strategy = GenerationType.AUTO)
	int id;
	@Column(name = "full_name", nullable = false)
	String fullName;
	@Column(name = "phone_numbers", nullable = false)
	@ElementCollection(fetch = FetchType.EAGER)
	List<String> phoneNumbers;
	@Column(name = "work_department")
	String workDepartment;
	
}
