package com.springboot.cache.hazelcast.service;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.springboot.cache.hazelcast.exception.EntityNotFoundException;
import com.springboot.cache.hazelcast.model.Employee;
import com.springboot.cache.hazelcast.repository.EmployeeRepository;

import lombok.extern.slf4j.Slf4j;

//lombok annotation
@Slf4j
//spring stereotype annotation
@Service
public class EmployeeService {

	@Autowired
	private EmployeeRepository repository;
	
	public long getTotalEmployees() {
		log.info("Getting total employees");
		return repository.count();
	}
	
	public void saveAll(final List<Employee> employees) {
		log.info("Saving all employees");
		repository.saveAll(employees);
	}
	
	public List<Employee> getEmployees() {
		log.info("Getting all employees");
		return repository.findAll();
	}
	
	public Employee getEmployee(final int id) throws EntityNotFoundException {
		log.info("Getting employee = {}", id);
		return repository.findById(id).orElseThrow(() -> new EntityNotFoundException(
				String.format("Employee %s not found", id)));
	}
}
