# python mysql

from connecttomysqldb import *


# executing the stored procedure to get all users
def get_users(conn):
    # creating a cursor to perform a sql operation
    cursor = conn.cursor()

    try:
        # execute the command
        cursor.callproc('get_users')

        # print results
        for result in cursor.stored_results():
            records = result.fetchall()
            if len(records) == 0:
                print('Empty table')
            else:
                # print results
                print('Printing user details')
                print('----------------------------')
                for record in records:
                    full_name = record[1] + " " + record[2]
                    print('Id = {}, Name = {}, Email = {}, Gender = {}'.format(record[0], full_name,
                                                                               record[3], record[4]))
    except(Exception, Error) as error:
        print(error)
    finally:
        if conn is not None:
            cursor.close()
            conn.close()
            print('\nConnection closed')


# executing the stored procedure to get user by id
def get_user_by_id(conn, uid):
    # creating a cursor to perform a sql operation
    cursor = conn.cursor()

    try:
        args = [uid]
        # execute the command
        cursor.callproc('get_user_by_id', args)

        # print results
        for result in cursor.stored_results():
            records = result.fetchall()
            if len(records) == 0:
                print('Empty table')
            else:
                # print results
                print('Printing user id = {} details'.format(uid))
                print('------------------------------------')
                for record in records:
                    full_name = record[0] + " " + record[1]
                    print('Name = {}, Email = {}, Gender = {}'.format(full_name, record[2], record[3]))
    except(Exception, Error) as error:
        print(error)
    finally:
        if conn is not None:
            cursor.close()
            conn.close()
            print('\nConnection closed')


# driver code
if __name__ == '__main__':
    get_users(connect())
    # get_user_by_id(connect(), 4)
