# python json tutorial

import json
import pathlib

# file params
file_path = 'config'
file_name = 'data.json'


def read_json(destination):
    # checking is file exists at the given destination or not
    if pathlib.Path(destination).exists():
        with open(destination, 'r') as f:
            data = json.load(f)

        if not data['person']:
            print('No data!')
        else:
            print('Data from json file')
            print('--------------------------')

            # printing json data in pretty print
            # print(json.dumps(data, indent=2))

            for rows in data['person']:
                full_name = rows['first_name'] + ' ' + rows['last_name']
                print('Id = {}, Full name = {}, Email = {}, Gender = {}'.format(
                    rows['id'], full_name, rows['email'], rows['gender']
                ))
    else:
        print('File not exist')


if __name__ == '__main__':
    read_json(file_path + '/' + file_name)
