# python enqueue and dqueue
# using list

class DQueue:
    # initialize the queue
    def __init__(self):
        self.queue = []

    # add an element to the queue
    def enqueue(self, item):
        max_size = 5
        if self.size() > max_size:
            print("Queue is full.")
        else:
            self.queue.append(item)

    # remove an element from the queue
    def dequeue(self):
        if self.size() < 1:
            return None
        return self.queue.pop(0)

    # display the queue elements
    def display(self):
        print(self.queue)

    # return the queue length
    def size(self):
        return len(self.queue)


# driver code
if __name__ == '__main__':
    q = DQueue()

    # adding elements to the queue
    for i in range(1, 6):
        q.enqueue(i)

    # display the queue elements
    print('Elements in queue.')
    q.display()

    # remove an element from the queue
    print('\nPopping out the element from the queue.')
    q.dequeue()  # removes '1'

    # display the queue elements
    print('\nAfter removing an element.')
    q.display()
