# useful methods under python list

# insert element in list at a given position
def insert_item_to_list(items, item, position):
    items.insert(position, item)
    print('List after insert = {}'.format(items))


# insert element at the end of the list
def append_item_to_list(items, item):
    items.append(item)
    print('List after append = {}'.format(items))


# remove element from the list
def remove_item_from_list(items, item_to_be_removed):
    try:
        print('Item to be removed = {}'.format(item_to_be_removed))
        items.remove(item_to_be_removed)
        print('List after remove = {}'.format(items))
    except ValueError:
        print('Item does not exist')


# merge two lists into one and store the merged items in first list
def merge_lists(list1, list2):
    list1.extend(list2)
    print('Updated list = {}'.format(list1))


# count the number of times a given item appears in the list
def count_element(items, search_key):
    count = items.count(search_key)
    print('{} appear {} times'.format(search_key, count))


# obtain the position of the item in the list
def find_item_pos(items, search_key):
    try:
        pos = items.index(search_key)
        print('{} found at position = {}'.format(search_key, (pos + 1)))
    except ValueError:
        print('Item does not exist')


# make a copy of the original list
def copy_list(items):
    copied_list = items.copy()
    print('Copied list = {}'.format(copied_list))


# sort the list in ascending order
def sorted_list(items):
    items.sort()
    print('Sorted list = {}'.format(items))


# reverse the items in the list
def reversed_list(items):
    items.reverse()
    print('Reversed list = {}'.format(items))


# remove all items from the list and return an empty list
def clear_list(items):
    items.clear()
    print('List cleared')


# remove the item from the list at a given index
def pop_item_from_list(items, index):
    popped_item = items.pop(index)
    print('Removed item = {}'.format(popped_item))
    print('Updated list = {}'.format(items))


# driver code
if __name__ == '__main__':
    phones = ['Apple', 'Android', 'Blackberry', 'Windows', 'Galaxy', 'HTC', 'LG']
    print('Original list = {}\n'.format(phones))

    # uncomment the method to check its working. have fun
    # insert_item_to_list(phones, 'Samsung', 3)
    # append_item_to_list(phones, 'Xperia')
    # remove_item_from_list(phones, 'LG')
    # merge_lists(phones, ['Wiko', 'Nokia'])
    # count_element(phones, 'Apple')
    # find_item_pos(phones, 'HTC')
    # copy_list(phones)
    # sorted_list(phones)
    # reversed_list(phones)
    # pop_item_from_list(phones, 2)
    clear_list(phones)
