package jcg.springboot.webflux.controller;

import jcg.springboot.webflux.response.EmployeeResponse;
import jcg.springboot.webflux.service.EmployeeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;

//lombok annotation
@Slf4j
//spring annotations
@RestController
@RequestMapping(value = "/api/stream")
public class FluxRestController {

    @Autowired
    private EmployeeService service;

    //url - http://localhost:9090/api/stream/employees
    @GetMapping(value = "/employees", produces = MediaType.TEXT_EVENT_STREAM_VALUE)
    public Flux<EmployeeResponse> streamStaticEmployeeEvents() {
        log.info("Streaming static employee events for flux.");
        return service.getEvents();
    }
}
