package jcg.springboot.webflux.repository;

import com.github.javafaker.Faker;
import jcg.springboot.webflux.model.Employee;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Random;
import java.util.UUID;

@Repository
public class ReactiveEmployeeRepository {

    private static final String[] GENDER = {"Male", "Female", "Not to specify"};
    private static final Random RANDOM = new Random();

    @Autowired
    private Faker faker;

    public Employee find() {
        //creating a dummy employee object and returning it.
        //ideally the data would be fetched from the rabbitmq where a subscriber would continuously
        //put in the queue.
        return createDummy();
    }

    private Employee createDummy() {
        final String firstName = faker.name().firstName();
        final String lastName = faker.name().lastName();
        final String emailAddress = firstName.toLowerCase() + "." + lastName.toLowerCase() + "@automation.com";
        final String gender = GENDER[RANDOM.nextInt(GENDER.length)];
        final LocalDateTime dateTime = LocalDateTime.parse(LocalDateTime.now().toString(),
                DateTimeFormatter.ISO_DATE_TIME);

        return Employee.builder()
                .id(RANDOM.nextInt())
                .firstName(firstName)
                .lastName(lastName)
                .gender(gender)
                .emailAddress(emailAddress)
                .phoneNumber(faker.phoneNumber().cellPhone())
                .createdAt(dateTime)
                .referenceId(UUID.randomUUID())
                .build();
    }
}
