package jcg.springboot.webflux.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import jcg.springboot.webflux.model.Employee;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.time.LocalDateTime;
import java.util.UUID;

//mapper class to map the employee entity response with the employee response class.

//lombok annotations
@AllArgsConstructor
@Getter
public class EmployeeResponse {

    @JsonProperty("id")
    UUID id;
    @JsonProperty("firstName")
    String firstName;
    @JsonProperty("lastName")
    String lastName;
    @JsonProperty("gender")
    String gender;
    @JsonProperty("emailAddress")
    String emailAddress;
    @JsonProperty("phoneNumber")
    String phoneNumber;
    @JsonProperty("doj")
    LocalDateTime doj;

    public static EmployeeResponse from(final Employee e) {
        return new EmployeeResponse(e.getReferenceId(),
                e.getFirstName(),
                e.getLastName(),
                e.getGender(),
                e.getEmailAddress(),
                e.getPhoneNumber(),
                e.getCreatedAt());
    }
}
