package jcg.springboot.webflux.service;

import jcg.springboot.webflux.repository.ReactiveEmployeeRepository;
import jcg.springboot.webflux.response.EmployeeResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import reactor.core.publisher.Flux;

import java.time.Duration;

//lombok annotation
@Slf4j
//spring annotation
@Service
public class EmployeeService {

    @Autowired
    ReactiveEmployeeRepository repository;

    public Flux<EmployeeResponse> getEvents() {
        log.info("Fetching the data from the queue or database.");
        return Flux.<EmployeeResponse>generate(synchronousSink -> {
            //for testing purpose we are keeping it simple
            //in ideal case the data needs to be pulled back from a queue for continuous emit
            final EmployeeResponse response = EmployeeResponse.from(repository.find());
            log.info("Returning employee with id = {}", response.getId());
            synchronousSink.next(response);
        }).delayElements(Duration.ofSeconds(2));
    }
}
