function loadEmployees() {
    console.log("Sending request to stream the server events.");

    this.source = null;
    this.start = function () {
        let table = document.getElementById("employees");
        this.source = new EventSource("/api/stream/employees");
        this.source.addEventListener("message", function (event) {
            let employee = JSON.parse(event.data);
            let row = table.getElementsByTagName("tbody")[0].insertRow(0);

            let cell0 = row.insertCell(0);
            let cell1 = row.insertCell(1);
            let cell2 = row.insertCell(2);
            let cell3 = row.insertCell(3);
            let cell4 = row.insertCell(4);
            let cell5 = row.insertCell(5);
            let cell6 = row.insertCell(6);

            cell0.innerHTML = employee.id;
            cell1.innerHTML = employee.firstName;
            cell2.innerHTML = employee.lastName;
            cell3.innerHTML = employee.gender;
            cell4.innerHTML = employee.emailAddress;
            cell5.innerHTML = employee.phoneNumber;
            cell6.innerHTML = employee.doj;
        });

        this.source.onerror = function () {
            this.close();
        };
    };

    this.stop = function () {
        this.source.close();
    }
}

load_employees = new loadEmployees();

//Register callbacks for starting and stopping the SSE controller.
window.onload = function () {
    load_employees.start();
};

window.onbeforeunload = function () {
    load_employees.stop();
}