# Modules
import connexion
from flask import jsonify

# Creating the application instance
app = connexion.App(__name__, specification_dir='./configure')

# Reading the swagger.yml file to configure the application endpoints
app.add_api('swagger.yml')


# Index endpoint
# URL - http://localhost:5000/
@app.route('/', methods=['GET'])
def home():
    print('Showing the index message')
    return jsonify({'message': 'Application is up and running'})


# Driver code
if __name__ == '__main__':
    app.run(debug=False)
