# Modules
from datetime import datetime

from flask import abort


def get_timestamp():
    return datetime.now().strftime('%Y-%m-%d %H:%M:%S')


# Mock employees data
EMPLOYEES = {
    '101': {
        'id': '101',
        'first_name': 'John',
        'last_name': 'Doe',
        'joined_on': get_timestamp()
    },
    '102': {
        'id': '102',
        'first_name': 'Maxim',
        'last_name': 'Klee',
        'joined_on': get_timestamp()
    },
    '103': {
        'id': '103',
        'first_name': 'Nonnah',
        'last_name': 'Kirkland',
        'joined_on': get_timestamp()
    },
    '104': {
        'id': '104',
        'first_name': 'Kit',
        'last_name': 'Tite',
        'joined_on': get_timestamp()
    },
    '105': {
        'id': '105',
        'first_name': 'Grannie',
        'last_name': 'Coulman',
        'joined_on': get_timestamp()
    }
}


# Return all employees
def read_all():
    print('Fetching all employees')
    return [EMPLOYEES[key] for key in EMPLOYEES.keys()]


# Return employee by id
def read_one(employee_id):
    print('Finding employee id = {}'.format(employee_id))
    for key in EMPLOYEES.keys():
        if key == employee_id:
            return EMPLOYEES[key]
    else:
        abort(404, 'Employee id = {} not found'.format(employee_id))
