package com.javacodegeeks.example;

import java.util.ArrayList;
import java.util.List;

public class JavaListToArrayExample {

    public static void main(String[] args) {
        // make a String ArrayList
        List<String> stringList = new ArrayList<String>();
        stringList.add("one");
        stringList.add("two");
        stringList.add("three");

        method_1_ListtoArray(stringList);
        method_2_ListtoArray(stringList);
        method_4_StreamtoArray(stringList);
        method_6_StreamtoArray(stringList);

        // to store custom objects
        List<User> userList = new ArrayList<User>();
        userList.add(new User("ani", "bha"));
        userList.add(new User("abcd", "pqrs"));

        method_3_ListtoArray(userList);
        method_5_StreamtoArray(userList);

    }

    private static void method_1_ListtoArray(List<String> stringList) {
        // Method 1 toArray()
        // Returns an array containing all of the elements in this list in proper sequence.

        Object[] array = stringList.toArray();

        System.out.println("*** Method 1 - iterating over the array ***");
        for (Object str : array) {
            System.out.println(str);
        }
    }

    private static void method_2_ListtoArray(List<String> stringList) {
        // Method 2 toArray(T[] a)
        // we are specifying the size of the array to which will be used
        String[] stringArray = stringList.toArray(new String[stringList.size()]);

        System.out.println("*** Method 2 - iterating over the array ***");
        for (String string : stringArray) {
            System.out.println(string);
        }
    }

    private static void method_3_ListtoArray(List<User> userList) {
        User[] userArray = userList.toArray(new User[userList.size()]);

        System.out.println("*** Method 3 - iterating over the array ***");
        for (User user : userArray) {
            System.out.println(user.toString());
        }
    }

    private static void method_4_StreamtoArray(List<String> stringList) {
        String[] stringArray = stringList.stream().toArray(String[]::new);
        System.out.println("*** Method 4 - iterating over the array ***");

        for (String string : stringArray) {
            System.out.println(string);
        }
    }

    private static void method_5_StreamtoArray(List<User> stringList) {
        User[] stringArray = stringList.stream().toArray(User[]::new);
        System.out.println("*** Method 5 - iterating over the array ***");
        for (User string : stringArray) {
            System.out.println(string);
        }
    }

    private static void method_6_StreamtoArray(List<String> stringList) {
        String[] stringArray = stringList.stream().toArray(ele -> new String[ele]);

        System.out.println("*** Method 6 - iterating over the array ***");
        for (String string : stringArray) {
            System.out.println(string);
        }
    }

}
