// importing module
var mysql = require('mysql');
// db configuration
const pool = mysql.createPool({
    connectionLimit: 5,
    host: 'localhost',
    user: 'root',
    password: 'password123',
    database: 'test',
    port: 3306
});

// basic endpoint

const index = (request, response) => {
    response.status(200).json({ info: 'Application started successfully' });
};

// health check endpoint

const health = (request, response) => {
    pool.getConnection(function (err, conn) {
        throwPoolError(err, response);
        conn.query('SELECT NOW()', (err, results) => {
            conn.release();   // return the connection to pool
            error(err, response);
            response.status(200).json({ info: 'Database is up and running' });
        });
    });
};

// application endpoints

// get all users
const getUsers = (request, response) => {
    console.log('Getting all users');
    pool.getConnection(function (err, conn) {
        throwPoolError(err, response);
        conn.query('SELECT * FROM users', (err, results) => {
            conn.release();   // return the connection to pool
            error(err, response);
            response.status(200).json({ info: results });
        });
    });
};

// get user by id
const getUserById = (request, response) => {
    const id = parseInt(request.params.id)
    console.log('Get user id = ' + id);
    pool.getConnection(function (err, conn) {
        throwPoolError(err, response);
        conn.query('SELECT * FROM users WHERE id = ?', [id], (err, results) => {
            conn.release();   // return the connection to pool
            error(err, response);
            response.status(200).json({ info: results });
        });
    });
};

// save new user
const save = (request, response) => {
    console.log('Saving new user');
    const { firstName, lastName, email, gender, phone } = request.body
    pool.query('INSERT INTO users (first_name, last_name, email, gender, phone) VALUES (?, ?, ?, ?, ?)',
        [firstName, lastName, email, gender, phone], (err, results) => {
            conn.release();   // return the connection to pool
            error(err, response);
            response.setHeader('created_id', `${results.insertId}`);
            response.status(201).json({ info: 'Resource created successfully' });
        });
};

// delete user by id
const deleteUser = (request, response) => {
    const id = parseInt(request.params.id);
    console.log('Delete user id = ' + id);
    pool.getConnection(function (err, conn) {
        throwPoolError(err, response);
        conn.query('DELETE FROM users WHERE id = ?', [id], (err, results) => {
            conn.release();   // return the connection to pool
            error(err, response);
            if (results.affectedRows == 0)
                response.status(400).json({ info: 'Resource not found' });
            else
                response.status(200).json({ info: `Resource deleted with id: ${id}` });
        });
    });
};

// update user by id
// db part skipped for brevity. you are free to play around
const updateUser = (request, response) => {
    const id = parseInt(request.params.id);
    console.log('Update user id = ' + id);
    response.status(204).json({ info: `Resource updated with id: ${id}` });
};


// helper methods
function throwPoolError(err, response) {
    if (err) {
        // console.log(err);
        response.status(503).json({ info: 'Cannot create connection with the pool' });
    }
}

function error(err, response) {
    if (err) {
        // console.log(err);
        response.status(503).json({ info: 'Some internal server error occurred' });
    }
}

module.exports = {
    index,
    health,
    getUsers,
    getUserById,
    deleteUser,
    updateUser,
    save
};
