# python datetime object tutorial

# importing module
from datetime import datetime, timedelta, date

import pytz


def get_current_date_time():
    now = datetime.now()
    print('Current date/time = {}'.format(now))


def get_current_date():
    now_date = date.today()
    print('Current date = {}'.format(now_date))


def convert_string_to_datetime(date_str):
    obj = datetime.strptime(date_str, '%B %d, %Y, %H:%M:%S')
    print('Date = {}'.format(obj.date()))
    print('Time = {}'.format(obj.time()))
    print('Date = {}'.format(obj))


def get_current_date_time_in_utc():
    now = datetime.now(pytz.utc)
    print('Current date/time in utc = {}'.format(now))


def get_timestamp_from_timestamp(timestamp):
    obj = datetime.fromtimestamp(timestamp)
    print('Date = {}'.format(obj))


def calculate_future_date(no_of_days):
    now = datetime.now()
    # calculating future date
    future = now + timedelta(days=no_of_days)
    print('Future date = {}'.format(future))


# driver code
if __name__ == '__main__':
    get_current_date_time()
    print('----')

    get_current_date()
    print('----')

    convert_string_to_datetime('November 5, 2020, 20:19:55')
    print('----')

    get_current_date_time_in_utc()
    print('----')

    get_timestamp_from_timestamp(1826254364)
    print('----')

    calculate_future_date(365)

print("\ndone")
