package com.springboot.flux.handler;

import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.function.server.ServerRequest;
import org.springframework.web.reactive.function.server.ServerResponse;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

import java.time.Duration;

//lombok annotation
@Slf4j
//spring annotation
@Component
public class MyHandler {

    //serves a plain text
    public Mono<ServerResponse> returnMonoResponse() {
        log.info("Returning a plain text");
        return ServerResponse.ok()
                .contentType(MediaType.TEXT_PLAIN)
                .body(Mono.just("Welcome to javacodegeeks.com"), String.class);
    }

    //serves a json stream
    public Mono<ServerResponse> returnFluxResponse() {
        log.info("Returning a json stream");
        return ServerResponse.ok()
                .contentType(MediaType.TEXT_EVENT_STREAM)
                .body(Flux.just("Welcome", "to", "javacodegeeks.com")
                        .delayElements(Duration.ofSeconds(2))
                        .log(), String.class);
    }

    //serves a json stream
    public Mono<ServerResponse> returnUserFluxResponse(final ServerRequest request) {
        final String name = request.pathVariable("name");
        log.info("Returning a username stream for = {}", name);
        return ServerResponse.ok()
                .contentType(MediaType.TEXT_EVENT_STREAM)
                .body(Flux.just("Welcome", name, "to", "javacodegeeks.com")
                        .delayElements(Duration.ofSeconds(2))
                        .log(), String.class);
    }
}
