package com.springboot.flux.routes;

import com.springboot.flux.handler.MyHandler;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.function.server.RouterFunctions;
import org.springframework.web.reactive.function.server.ServerResponse;

//spring annotation
@Configuration
public class MyRoutes {

    //spring annotation
    @Bean
    public RouterFunction<ServerResponse> functionalRoutes(final MyHandler handler) {
        return RouterFunctions.route()
                .GET("/api/mono", request -> handler.returnMonoResponse())      // http://localhost:9091/api/mono
                .GET("/api/flux", request -> handler.returnFluxResponse())              // http://localhost:9091/api/flux
                .GET("/user/flux/{name}", handler::returnUserFluxResponse)          // http://localhost:9091/user/flux/daniel
                .build();
    }
}
