package com.javacodegeek.demo.bootstrap;

import com.javacodegeek.demo.model.Employee;
import com.javacodegeek.demo.service.EmployeeService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

//lombok annotation
@Slf4j
//spring annotation
@Component
public class DefaultEmployeesLoader implements CommandLineRunner {

    @Autowired
    EmployeeService service;

    @Override
    public void run(String... args) {
        service.save(createEmployees());
    }

    private List<Employee> createEmployees() {
        final List<Employee> employees = new ArrayList<>();
        employees.add(create("Petey", "Carlson", "pcarlson0@dmoz.org", "707-179-2464"));
        employees.add(create("Jasmina", "Snead", "jsnead1@microsoft.com", "455-239-8545"));
        employees.add(create("Pollyanna", "Vaudre", "pvaudre2@w3.org", null));
        employees.add(create("Rutter", "Petriello", "rpetriello3@cbsnews.com", "949-531-9171"));
        employees.add(create("Grange", "Sowerbutts", "gsowerbutts4@simplemachines.org", "378-268-7102"));

        return employees;
    }

    private Employee create(final String firstName, final String lastName, final String email, final String phone) {
        return Employee.builder()
                .firstName(firstName)
                .lastName(lastName)
                .emailAddress(email)
                .phone(phone)
                .build();
    }
}
